import os

from utils.folder import clear_folder


def initialize(cfg):
    if cfg.DEBUG.INIT_ATTR:
        # remove encoding.npy
        if os.path.isfile(cfg.ATTR.ENCODING):
            os.remove(cfg.ATTR.ENCODING)
        # remove unknown face folder
        if os.path.isdir(cfg.ATTR.UNKNOWN):
            clear_folder(cfg.ATTR.UNKNOWN)
        # remove person gallery
        if os.path.isdir(cfg.REID.GALLERY):
            clear_folder(cfg.REID.GALLERY)

    if cfg.DEBUG.INIT_REID:
        # remove reid unknown
        if os.path.isdir(cfg.REID.UNKNOWN):
            clear_folder(cfg.REID.UNKNOWN)
        # remove statistics results
        if os.path.isfile(cfg.REID.RESULT):
            os.remove(cfg.REID.RESULT)
