import cv2
import numpy as np
import time


def create_rgb_hist(image):
    image = cv2.cvtColor(image, cv2.COLOR_BGR2HSV)
    hsvhist = np.zeros([256 * 256 * 256, 1], np.float32)
    for i in range(3):
        hsvhist[255 * i:255 * (i + 1)] = cv2.calcHist([image], [i], None, [255], [0, 255])
    return hsvhist


def get_key(dict, value):
    return [k for k, v in dict.items() if v == value]


def hist_compare(image1, image2):
    hist1 = create_rgb_hist(image1)
    hist2 = create_rgb_hist(image2)
    match1 = cv2.compareHist(hist1, hist2, cv2.HISTCMP_BHATTACHARYYA)
    match2 = cv2.compareHist(hist1, hist2, cv2.HISTCMP_CORREL)
    match3 = cv2.compareHist(hist1, hist2, cv2.HISTCMP_CHISQR)
    return match1, match2, match3


def normalize(BD, RE, CD):
    result = (BD + (1 - RE) + (CD / 2 / 3E5 if CD < 3E5 else 1)) / 3
    return result


def comp(ori, comp):
    result_person = dict()
    is_same_per = False
    if not len(ori) == len(comp):
        return None
    for ii, ori_per in enumerate(ori):
        result = []
        normal_result = []
        for target in comp:
            BD, RE, CD = hist_compare(ori_per, target)
            normalized_result = normalize(BD, RE, CD)
            normal_result.append(normalized_result)
            result.append([BD, RE, CD])
        min_sim = min(normal_result)
        index = normal_result.index(min_sim)
        [BD, RE, CD] = result[index]
        if RE > 0.95 and BD < 0.3 and CD < 3E5 and min_sim < 0.20:
            is_same_per = True
        elif min_sim < 0.10:
            is_same_per = True
        if is_same_per:
            result_person[ii] = index
        else:
            result_person[ii] = None
    return result_person
