import multiprocessing
import os
from multiprocessing import Process

from attr_main import attr_main
from attribute_detect.inference import start_attr_det
from config import config as cfg
from reid_main import reid_main
from utils.capture import start_streams
from utils.initialize import initialize
from yolov3.yolo_detect import set_yolo

if __name__ == '__main__':
    os.environ['PYTHONWARNINGS'] = 'ignore:semaphore_tracker:UserWarning'
    multiprocessing.set_start_method('forkserver', force=True)
    initialize(cfg)
    start_streams(cfg, ('attr', 'reid'))
    start_attr_det(cfg)
    set_yolo(cfg, ('attr', 'reid'))

    attr_proc = Process(target=attr_main, args=(cfg,))
    reid_proc = Process(target=reid_main, args=(cfg,))
    attr_proc.start()
    reid_proc.start()

    procs = [attr_proc, reid_proc]

    for p in procs:
        p.join()
