import cv2


def drawtransrect(img, x1, y1, x2, y2, BGR, alpha):  # 在区域内画填充的透明矩形
    h, w, s = img.shape
    blue = BGR[0]
    green = BGR[1]
    red = BGR[2]

    if y1 < 0:
        y1 = 0
    if x1 < 0:
        x1 = 0
    if y2 > h:
        y2 = h
    if x2 > w:
        x2 = w

    img[y1:y2, x1:x2, 0] = img[y1:y2, x1:x2, 0] * alpha + blue
    img[y1:y2, x1:x2, 1] = img[y1:y2, x1:x2, 1] * alpha + green
    img[y1:y2, x1:x2, 2] = img[y1:y2, x1:x2, 2] * alpha + red

    return img


def draw_info_dict(img_list, info, text_color=(0, 0, 255), rect_color=(124, 0, 0), alpha=0.5,
                   font=cv2.FONT_HERSHEY_DUPLEX, font_size=1, thick=2):
    result = []
    for img in img_list:
        h, w, s = img[1].shape  # 图片高、宽、色度
        i = 0  # 记录行数
        string_len_max = 0  # 记录字符串中字符最长行的长度
        start_position = (int(0.05 * w), int(0.05 * h))  # 文字输出的开始位置

        for myinfo in info:
            if i == 0:  # 打印表头
                id_size = cv2.getTextSize(myinfo, font, font_size, thick)
                all_zone_names = list(info[myinfo].keys())
                single_font_width = int(id_size[0][0] / len(myinfo))
                single_font_height = id_size[0][1] * 2  # 两倍行距

                text = ""
                for zone_name in all_zone_names:
                    text = text + "%+6s" % zone_name
                text_size = cv2.getTextSize(text, font, font_size, thick)

                x1 = start_position[0] - single_font_width  # 矩形初始x位置，为本行文字开始处前一个字符宽度的位置
                y1 = start_position[1] - single_font_height  # 矩形初始y位置，为本行文字开始处上方一行文字高度的位置
                x2 = start_position[0] + id_size[0][0] + text_size[0][
                    0] + single_font_width  # 矩形结束x位置，为最后一个文字后一个字符宽度的位置
                y2 = start_position[1]  # 矩形结束y位置，为本行文字的位置
                img[1] = drawtransrect(img[1], x1, y1, x2, y2, rect_color, alpha)

                x = id_size[0][0] + start_position[0]
                y = start_position[1]
                cv2.putText(img[1], text, (x, y), font, font_size, text_color, thick)

                i = i + 1

            # 输出信息
            text = "%+5s" % myinfo
            for zone_name in all_zone_names:
                text = text + "%+6s" % info[myinfo][zone_name]
            # text_size = cv2.getTextSize(text,font,font_size,thick)

            y1 = start_position[1] + (i - 1) * single_font_height  # 矩形初始y位置，为本行文字开始处上方一行文字高度的位置
            y2 = start_position[1] + i * single_font_height  # 矩形结束y位置，为本行文字的位置
            img[1] = drawtransrect(img[1], x1, y1, x2, y2, rect_color, alpha)
            cv2.putText(img[1], text, (start_position[0], y2), font, font_size, text_color, thick)

            i = i + 1

        img[1] = drawtransrect(img[1], x1, y2, x2, y2 + int(single_font_height / 2), rect_color, alpha)
        result.append(img[1])
    return result


def draw_info_str(img_list, info, pt, text_color=(0, 0, 255), rect_color=(0, 0, 0), alpha=0.5,
                  font=cv2.FONT_HERSHEY_DUPLEX, font_size=1, thick=2):
    result = []
    for point, img in zip(pt, img_list):
        h, w, s = img[1].shape  # 图片高、宽、色度
        x = point[0]
        y = point[1]
        x = int(x + 0.01 * w)
        y = int(y - 0.01 * h)
        size = cv2.getTextSize(info, font, font_size, thick)
        # img[1] = drawtransrect(img[1], x, y, x + size[0][0], y + size[0][1], rect_color, alpha)
        cv2.putText(img[1], info, (x, y), font, font_size, text_color, thick)
        result.append(img[1])
    return result


def drawing(task='dict', imgs_list=[], info=None, text_color=(0, 0, 255), rect_color=(124, 0, 0), alpha=0.5,
            font=cv2.FONT_HERSHEY_DUPLEX, font_size=1, thick=2, pt=(0, 0)):
    assert task in ['dict', 'str'], 'Unknown task: {:s}'.format(imgs_list)
    if task == 'dict':
        result = draw_info_dict(imgs_list, info, text_color, rect_color, alpha, font, font_size, thick)
    else:
        result = draw_info_str(imgs_list, info, pt, text_color, (0,0,0), alpha, font, font_size, thick)
    return result

# img_1 = cv2.imread('1.png')
#
# info = {'1001': {'109': 0, '110': 0, '111': 0, '112': 0, '113': 0, '114': 0, '115': 0, '116': 0, '118': 0},
#         '1003': {'109': 0, '110': 0, '111': 0, '112': 0, '113': 0, '114': 0, '115': 0, '116': 0, '118': 0},
#         '1002': {'109': 0, '110': 0, '111': 0, '112': 0, '113': 5, '114': 0, '115': 0, '116': 0, '118': 0}}
# img_list = [img_1]
# img_list = draw_info(img_list, info)
