import face_recognition
import numpy as np

from config import config as cfg
from face_detect.face_detection_and_recognition_3 import unique_face
from utils.logger import LOGGER

ENCODE_PATH = cfg.ATTR.ENCODING


def face_detection_and_recognition_2(rgb_frame, known_faces, tolerance_high=0.50, tolerance_low=0.45):
    face_name = None
    face_locations = face_recognition.face_locations(rgb_frame)

    if len(face_locations) == 0:
        LOGGER.debug('no face detected.')
        return face_name, known_faces, None
    face_landmarks_list = face_recognition.face_landmarks(rgb_frame)  # obtain the landmarks

    # dis1 is the distance of eyes and mouth
    dis1 = face_landmarks_list[0]['bottom_lip'][0][1] - face_landmarks_list[0]['right_eye'][0][1]
    if dis1 < 25:
        LOGGER.info('faces are too small.')
        return face_name, known_faces, None

    dis2 = (face_landmarks_list[0]['left_eye'][5][0] - face_landmarks_list[0]['left_eye'][0][0]) - (
            face_landmarks_list[0]['right_eye'][5][0] - face_landmarks_list[0]['right_eye'][0][0])
    dis2 = dis2 * dis2
    if dis2 > 1:
        LOGGER.debug("the face is not frontal with distance {:}".format(dis2))
        return None, known_faces, None

    face_locations, rgb_frame = unique_face(face_locations, rgb_frame)
    face_encodings = face_recognition.face_encodings(rgb_frame, face_locations)

    assert len(face_encodings) == 1, 'after unique should only have one face'

    face_encoding = face_encodings[0].reshape((1, 128))
    if len(known_faces) == 0:
        LOGGER.info("new client assigned new ID: {:d}".format(1001))
        face_name = 1001
        np.save(ENCODE_PATH, face_encoding)
        known_faces = face_encoding
    else:
        distances = face_recognition.face_distance(known_faces, face_encoding)
        min_dis = np.min(distances)
        min_index = np.argwhere(distances == min_dis)[0][0]

        LOGGER.debug('min distance {:}'.format(min_dis))
        if min_dis > tolerance_high:  # different from all persons in the gallery
            LOGGER.info("new client assigned new ID: {:d}".format(1001 + len(known_faces)))
            face_name = 1001 + len(known_faces)
            known_faces = np.vstack((known_faces, face_encoding))
            np.save(ENCODE_PATH, known_faces)
        elif min_dis < tolerance_low:
            LOGGER.info('the person is {:d}'.format(1001 + min_index))
            face_name = 1001 + min_index
        else:
            return None, known_faces, None

    return face_name, known_faces, face_encoding
